
<?php $__env->startSection('title'); ?>
    <?php echo app('translator')->get('academics.sessions'); ?>
<?php $__env->stopSection(); ?>




<?php $__env->startSection('mainContent'); ?>
    <section class="sms-breadcrumb mb-20">
        <div class="container-fluid">
            <div class="row justify-content-between">
                <h1><?php echo app('translator')->get('academics.track_session'); ?></h1>
                <div class="bc-pages">
                    <a href="<?php echo e(route('dashboard')); ?>"><?php echo app('translator')->get('common.dashboard'); ?></a>
                    <a><?php echo app('translator')->get('academics.academics'); ?></a>
                    <a href="<?php echo e(route('tracks')); ?>"><?php echo app('translator')->get('academics.track'); ?></a>
                    <a href="<?php echo e(route('track_levels', ['track_id' => $track->id])); ?>"><?php echo app('translator')->get('academics.levels'); ?></a>
                    <a><?php echo app('translator')->get('common.session'); ?></a>
                </div>
            </div>
        </div>
    </section>
    <section class="admin-visitor-area up_admin_visitor up_st_admin_visitor pl_22">
        <div class="container-fluid p-0">
            <?php if(isset($discountPlan)): ?>
                <?php if(userPermission('track_sessions-store')): ?>
                    <div class="row">
                        <div class="offset-lg-10 col-lg-2 text-right col-md-12 mb-20">
                            <a href="<?php echo e(route('track_sessions')); ?>" class="primary-btn small fix-gr-bg">
                                <span class="ti-plus pr-2"></span>
                                <?php echo app('translator')->get('common.add'); ?>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
            <div class="row">

                <div class="col-md-6">
                    <div class="d-flex align-items-center">
                        <div class="btnSelect">

                            <button id="add_btn" class="circular-btn mx-2" aria-label="Toggle new session form">
                                <i class="fas fa-plus" style="color: #fff"></i>
                            </button>
                        </div>
                        <div id="add_session" class="input-session" style="display: none;width:100%">
                            <button id="modal_btn" class="session-btn">
                                <i class="fas fa-plus" style="color: #000000"></i> <?php echo app('translator')->get('academics.session'); ?>
                            </button>
                        </div>
                    </div>
                </div>


                <!-- Modal -->
                <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog">
                        <form action="<?php echo e(route('track_levels_sessions_store')); ?>" method="POST"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>


                            <div class="modal-content">

                                <div class="modal-header">
                                    <h1 class="modal-title fs-5" id="exampleModalLabel"><?php echo app('translator')->get('academics.add_session'); ?></h1>
                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                </div>
                                <div class="modal-body">

                                    <input type="hidden" id="track_id" name="track_id" value="<?php echo e($track->id); ?>">
                                    <input type="hidden" id="level_id" name="level_id" value="<?php echo e($level->id); ?>">


                                    <div class="primary_input">
                                        <label class="primary_input_label" for="name_en"><?php echo app('translator')->get('academics.name_en'); ?>
                                            <span class="text-danger"> *</span>
                                        </label>
                                        <input class="primary_input_field form-control" type="text" name="name_en"
                                            id="name_en" autocomplete="off">
                                    </div>

                                    <div class="primary_input">
                                        <label class="primary_input_label" for="name_ar"><?php echo app('translator')->get('academics.name_ar'); ?>
                                            <span class="text-danger"> *</span>
                                        </label>
                                        <input class="primary_input_field form-control" type="text" id="name_ar"
                                            name="name_ar" autocomplete="off">
                                    </div>
                                    <div class="primary_input">
                                        <label class="primary_input_label" for="description_en"><?php echo app('translator')->get('academics.description_en'); ?>
                                            <span class="text-danger"> *</span>
                                        </label>
                                        <input class="primary_input_field form-control" type="text" name="description_en"
                                            id="description_en" autocomplete="off">
                                    </div>

                                    <div class="primary_input">
                                        <label class="primary_input_label" for="description_ar"><?php echo app('translator')->get('academics.description_ar'); ?>
                                            <span class="text-danger"> *</span>
                                        </label>
                                        <input class="primary_input_field form-control" type="text" id="description_ar"
                                            name="description_ar" autocomplete="off">
                                    </div>

                                    <div class="primary_input">
                                        <label class="primary_input_label" for="file"><?php echo app('translator')->get('common.material'); ?>
                                            <span class="text-danger"> *</span>
                                        </label>
                                        <input class="primary_input_field form-control" id="file" type="file"
                                            multiple id="file" name="file[]" autocomplete="off">
                                    </div>

                                </div>
                                <div class="modal-footer">

                                    <button type="submit" id="add_for_submit" class="primary-btn fix-gr-bg text-nowrap">
                                        <?php echo app('translator')->get('common.submit'); ?>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>



                <!-- Modal Update -->
                <div class="modal fade" id="ModalUpdateSession" tabindex="-1" aria-labelledby="ModalLabelUpdateSession"
                    aria-hidden="true">
                    <div class="modal-dialog">
                        <form action="<?php echo e(route('track_levels_sessions_update')); ?>" method="POST"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h1 class="modal-title fs-5" id="ModalLabelUpdateSession"><?php echo app('translator')->get('academics.update_session'); ?></h1>
                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                </div>
                                <div class="modal-body">
                                    <input type="hidden" id="update_track_id" name="track_id">
                                    <input type="hidden" id="update_level_id" name="level_id">
                                    <input type="hidden" id="update_session_id" name="id">

                                    <div class="primary_input">
                                        <label class="primary_input_label" for="update_name_en"><?php echo app('translator')->get('academics.name_en'); ?>
                                            <span class="text-danger"> *</span>
                                        </label>
                                        <input class="primary_input_field form-control" type="text" name="name_en"
                                            id="update_name_en" autocomplete="off">
                                    </div>

                                    <div class="primary_input">
                                        <label class="primary_input_label" for="update_name_ar"><?php echo app('translator')->get('academics.name_ar'); ?>
                                            <span class="text-danger"> *</span>
                                        </label>
                                        <input class="primary_input_field form-control" type="text" name="name_ar"
                                            id="update_name_ar" autocomplete="off">
                                    </div>

                                    <div class="primary_input">
                                        <label class="primary_input_label" for="update_description_en"><?php echo app('translator')->get('academics.description_en'); ?>
                                            <span class="text-danger"> *</span>
                                        </label>
                                        <input class="primary_input_field form-control" type="text"
                                            name="description_en" id="update_description_en" autocomplete="off">
                                    </div>

                                    <div class="primary_input">
                                        <label class="primary_input_label" for="update_description_ar"><?php echo app('translator')->get('academics.description_ar'); ?>
                                            <span class="text-danger"> *</span>
                                        </label>
                                        <input class="primary_input_field form-control" type="text"
                                            name="description_ar" id="update_description_ar" autocomplete="off">
                                    </div>

                                    <!-- Display existing files -->
                                    <div class="primary_input">
                                        <label class="primary_input_label"><?php echo app('translator')->get('common.existing_materials'); ?></label>
                                        <div id="existing_files">
                                            <!-- Files will be dynamically added here -->
                                        </div>
                                    </div>

                                    <div class="primary_input">
                                        <label class="primary_input_label" for="update_file"><?php echo app('translator')->get('common.material'); ?>
                                            <span class="text-danger"> *</span>
                                        </label>
                                        <input class="primary_input_field form-control" type="file" name="file[]"
                                            id="update_file" multiple autocomplete="off">
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="submit"
                                        class="primary-btn fix-gr-bg text-nowrap"><?php echo app('translator')->get('common.update'); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </section>


    <section>

        <?php echo $__env->make('backEnd.academics.sessions.session_card', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </section>
<?php $__env->stopSection(); ?>

<style>
    .btnSelect {
        border-radius: 50%;
        display: flex;
        align-items: center;
    }

    .btnSelect .circular-btn {
        border-radius: 50%;
        padding: 16px 17px;

    }

    .btnSelect .fa {
        padding: 15px;
    }

    .circular-btn {

        background-color: #3f4d8f;
        border: none;
        color: #fff;
    }

    .circular-btn:hover {
        background-color: #212c60;
    }

    .input-session {
        padding: 8px 12px;
        border-radius: 4px;
        background: #fff;
        box-shadow: 0px 4px 20px rgba(39, 32, 120, 0.1)
    }

    .session-btn {
        background: none;
        border: none;
    }

    .session-btn:hover {
        color: #007bff;
    }
</style>
<?php $__env->startPush('scripts'); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        $(document).ready(function() {
            $('#add_btn').click(function(event) {
                event.preventDefault();
                event.stopPropagation();
                $('#add_session').toggle();
                if ($('#add_session').is(':visible')) {
                    $(this).html('<i class="fas fa-times" style="color: #fff"></i>');
                } else {
                    $(this).html('<i class="fas fa-plus" style="color: #fff"></i>');
                }
            });

            $(document).on('click', function(event) {
                if (!$(event.target).closest('#add_session').length && !$(event.target).closest(
                        '#add_btn').length) {
                    $('#add_session').hide();
                    $('#add_btn').html('<i class="fas fa-plus" style="color: #fff"></i>');
                }
            });

            $('#modal_btn').click(function(event) {
                event.preventDefault();
                $('#exampleModal').modal('show');
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('backEnd.partials.data_table_js', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('backEnd.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\tailors-dev\upedia\resources\views/backEnd/academics/sessions/index.blade.php ENDPATH**/ ?>